#include "MTMenuBar.h"
#include "IErrors.h"

MTMenuBar	* gTheMenuBar;

//	MTMenuBar::MTMenuBar()
//	
//	constructor, sets global variable to point to this instance
MTMenuBar::MTMenuBar()
{
	gTheMenuBar = this;
}

//	MTMenuBar::~MTMenuBar()
//	
//	desctructor, invalidates global pointer
MTMenuBar::~MTMenuBar()
{
	gTheMenuBar = nil;
}

//	void MTMenuBar::InstallMBAR(SInt16 id)
//	
//	installs a MBAR resource
//	
//	id = resource id of target MBAR
void MTMenuBar::InstallMBAR(SInt16 id)
{
	Handle	menuBar;
	
	menuBar = GetNewMBar(id);
	if(!menuBar)
	{
		DoFatalError("Couldn't load menu bar resource");
		
		ExitToShell();
	}
	
	SetMenuBar(menuBar);
	
	DisposeHandle(menuBar);
	
	AppendResMenu(GetMenuHandle(kAppleMenu), 'DRVR');
	
	DrawMenuBar();
}

//	MenuHandle MTMenuBar::MyGetMenuHandle(SInt16 id)
//	
//	given a menu ID, returns a MenuHandle
//	
//	id = menu id
//	returns handle to menu record
MenuHandle MTMenuBar::MyGetMenuHandle(SInt16 id)
{
	for(UInt32 i = 0; i < menuList.size(); i++)
		if(menuList[i].id == id)
			return menuList[i].menu;
	
	MTMenuEntry	entry;
	
	entry.id = id;
	entry.menu = GetMenu(id);
	if(!entry.menu)
	{
		DoFatalError("Couldn't load menu resource");
		
		ExitToShell();
	}
	
	HLockHi((Handle)entry.menu);
	
	menuList.push_back(entry);
	
	return entry.menu;
}

//	void MTMenuBar::EnableItem(SInt16 menuID, SInt16 itemID)
//	
//	enables a menu item
//	
//	menuID = menu id
//	itemID = item id
void MTMenuBar::EnableItem(SInt16 menuID, SInt16 itemID)
{
	EnableMenuItem(MyGetMenuHandle(menuID), itemID);
}

//	void MTMenuBar::DisableItem(SInt16 menuID, SInt16 itemID)
//	
//	disables a menu item
//	
//	menuID = menu id
//	itemID = item id
void MTMenuBar::DisableItem(SInt16 menuID, SInt16 itemID)
{
	DisableMenuItem(MyGetMenuHandle(menuID), itemID);
}

//	void MTMenuBar::CheckItem(SInt16 menuID, SInt16 itemID, char markType)
//	
//	marks a menu item
//	
//	menuID = menu id
//	itemID = item id
//	markType = type of mark to use (defaults to check)
void MTMenuBar::CheckItem(SInt16 menuID, SInt16 itemID, char markType)
{
	SetItemMark(MyGetMenuHandle(menuID), itemID, markType);
}

//	void MTMenuBar::UncheckItem(SInt16 menuID, SInt16 itemID)
//	
//	unchecks a menu item
//	
//	menuID = menu id
//	itemID = item id
void MTMenuBar::UncheckItem(SInt16 menuID, SInt16 itemID)
{
	SetItemMark(MyGetMenuHandle(menuID), itemID, noMark);
}

//	void MTMenuBar::EnableMenu(SInt16 menuID)
//	
//	enables a menu
//	
//	menuID = menu id
void MTMenuBar::EnableMenu(SInt16 menuID)
{
	EnableMenuItem(MyGetMenuHandle(menuID), 0);
}

//	void MTMenuBar::DisableMenu(SInt16 menuID)
//	
//	disables a menu
//	
//	menuID = menu id
void MTMenuBar::DisableMenu(SInt16 menuID)
{
	DisableMenuItem(MyGetMenuHandle(menuID), 0);
}

//	void MTMenuBar::UpdateMenuBar(void)
//	
//	redraws the menu bar
void MTMenuBar::UpdateMenuBar(void)
{
	DrawMenuBar();
}